
COMMENT: Replication of Table 7-6.
COMMENT: This syntax is copyright by Robert B. Smith,  2011.

WEIGHT Off.

COMMENT: INTERCEPTS Only Model.
COMMENT: Same as SAS.
MIXED HDIINDEX
  /CRITERIA=CIN(95) MXITER(100) MXSTEP(10) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, 
    ABSOLUTE) LCONVERGE(0, ABSOLUTE) PCONVERGE(0.000001, ABSOLUTE)
  /FIXED=| SSTYPE(3)
  /METHOD=REML
  /PRINT=DESCRIPTIVES  SOLUTION TESTCOV
  /RANDOM=INTERCEPT | SUBJECT(REGION) COVTYPE(VC)
  /REGWGT=Sqrtpop
  /EMMEANS=TABLES(OVERALL).


COMMENT: FULL DESCRIPTIVE MODEL.
COMMENT: Same as SAS.
MIXED HDIINDEX BY CULTURE WITH emancip dichofre lodebt nochaos integrit
  /CRITERIA=CIN(95) MXITER(100) MXSTEP(10) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, 
    ABSOLUTE) LCONVERGE(0, ABSOLUTE) PCONVERGE(0.000001, ABSOLUTE)
  /FIXED= CULTURE  emancip dichofre lodebt nochaos integrit| SSTYPE(3)
  /METHOD=REML
  /PRINT= SOLUTION TESTCOV
  /RANDOM=INTERCEPT | SUBJECT(REGION) COVTYPE(VC)
  /REGWGT=Sqrtpop
  /EMMEANS=TABLES(OVERALL).


COMMENT: Region Classified by Culture and No Chaos.
COMMENT: SAME as SAS.
MIXED HDIINDEX BY CULTURE WITH emancip dichofre lodebt nochaos integrit
  /CRITERIA=CIN(95) MXITER(100) MXSTEP(10) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, 
    ABSOLUTE) LCONVERGE(0, ABSOLUTE) PCONVERGE(0.000001, ABSOLUTE)
  /FIXED= CULTURE  emancip dichofre lodebt nochaos integrit| SSTYPE(3)
  /METHOD=REML
  /PRINT= SOLUTION TESTCOV
  /RANDOM=INTERCEPT | SUBJECT(REGION*CULTURE*NOCHAOS) COVTYPE(VC)
  /REGWGT=Sqrtpop
  /EMMEANS=TABLES(OVERALL).

COMMENT: Region Classified by Emancipatory Employment and No Chaos.
COMMENT: Results the same as from SAS when SLAVE98 is classification variable.
MIXED HDIINDEX BY CULTURE WITH emancip dichofre lodebt nochaos integrit
  /CRITERIA=CIN(95) MXITER(100) MXSTEP(10) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, 
    ABSOLUTE) LCONVERGE(0, ABSOLUTE) PCONVERGE(0.000001, ABSOLUTE)
  /FIXED= CULTURE  emancip dichofre lodebt nochaos integrit| SSTYPE(3)
  /METHOD=REML
  /PRINT= SOLUTION TESTCOV
  /RANDOM=INTERCEPT | SUBJECT(REGION*Slave98*NOCHAOS) COVTYPE(VC)
  /REGWGT=Sqrtpop
  /EMMEANS=TABLES(OVERALL).

COMMENT: Region Classified by Dichotomized Freedom and No Chaos.
COMMENT: Results Same as those from SAS.
MIXED HDIINDEX BY CULTURE WITH emancip dichofre lodebt nochaos integrit
  /CRITERIA=CIN(95) MXITER(100) MXSTEP(10) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, 
    ABSOLUTE) LCONVERGE(0, ABSOLUTE) PCONVERGE(0.000001, ABSOLUTE)
  /FIXED= CULTURE  emancip dichofre lodebt nochaos integrit| SSTYPE(3)
  /METHOD=REML
  /PRINT= SOLUTION TESTCOV
  /RANDOM=INTERCEPT | SUBJECT(REGION*dichofre*NOCHAOS) COVTYPE(VC)
  /REGWGT=Sqrtpop
  /EMMEANS=TABLES(OVERALL).


COMMENT: Region Classified by Dichotomized Debt and No Chaos.
COMMENT: Results Same as those from SAS.
MIXED HDIRANK BY CULTURE WITH emancip dichofre lodebt nochaos integrit
  /CRITERIA=CIN(95) MXITER(100) MXSTEP(10) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, 
    ABSOLUTE) LCONVERGE(0, ABSOLUTE) PCONVERGE(0.000001, ABSOLUTE)
  /FIXED= CULTURE  emancip dichofre lodebt nochaos integrit| SSTYPE(3)
  /METHOD=REML
  /PRINT= SOLUTION TESTCOV
  /RANDOM=INTERCEPT | SUBJECT(REGION*lodebt*NOCHAOS) COVTYPE(VC)
  /REGWGT=Sqrtpop
  /EMMEANS=TABLES(OVERALL).

COMMENT: Region Classified by Dichotomized No Chaos.
COMMENT: Results Same as those from SAS.
MIXED HDIINDEX BY CULTURE WITH emancip dichofre lodebt nochaos integrit
  /CRITERIA=CIN(95) MXITER(100) MXSTEP(10) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, 
    ABSOLUTE) LCONVERGE(0, ABSOLUTE) PCONVERGE(0.000001, ABSOLUTE)
  /FIXED= CULTURE  emancip dichofre lodebt nochaos integrit| SSTYPE(3)
  /METHOD=REML
  /PRINT= SOLUTION TESTCOV
  /RANDOM=INTERCEPT | SUBJECT(REGION*NOCHAOS) COVTYPE(VC)
  /REGWGT=Sqrtpop
  /EMMEANS=TABLES(OVERALL).


COMMENT: Region Classified by Dichotomized Corruption and No Chaos.
COMMENT: Results Same as those from SAS.
MIXED HDIINDEX BY CULTURE WITH emancip dichofre lodebt nochaos integrit
  /CRITERIA=CIN(95) MXITER(100) MXSTEP(10) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, 
    ABSOLUTE) LCONVERGE(0, ABSOLUTE) PCONVERGE(0.000001, ABSOLUTE)
  /FIXED= CULTURE  emancip dichofre lodebt nochaos integrit| SSTYPE(3)
  /METHOD=REML
  /PRINT= SOLUTION TESTCOV
  /RANDOM=INTERCEPT | SUBJECT(REGION*Integrit*NOCHAOS) COVTYPE(VC)
  /REGWGT=Sqrtpop
  /EMMEANS=TABLES(OVERALL).


DATASET ACTIVATE DataSet1.

WEIGHT Off.

COMMENT:  Interpretation of Explanatory Effects.
COMMENT: These Spearman Correlations differ from those of SAS because here there is no 
Weight by the square root of the population.

NONPAR CORR
  /VARIABLES=emancip dichofre HDIIndex
  /PRINT=SPEARMAN TWOTAIL NOSIG
  /MISSING=PAIRWISE.

NONPAR CORR
  /VARIABLES=emancip dichofre HDIRANK
  /PRINT=SPEARMAN TWOTAIL NOSIG
  /MISSING=PAIRWISE.
